<?php

namespace App\Http\Controllers;
use App\Models\AddressModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

use Illuminate\Http\Request;

class AddressController extends Controller
{
    function getDataById($id)
    {

      $data = DB::table("user_address")
      ->select('user_address.*')
       ->where("user_address.id","=",$id)
        ->first();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function getDataByUserId($id)
    {

      $data = DB::table("user_address")
      ->select('user_address.*')
    
       ->where("user_address.user_id","=",$id)
       ->orderBy('user_address.created_at','DESC')
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function addData(Request $request)
    {
        
        $validator = Validator::make(request()->all(), [
            'user_id' => 'required',
            'name' => 'required',
            's_phone' => 'required',
            'landmark' => 'required',
            'pincode' => 'required',
            'city' => 'required'
            
    ]);
  
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
        
                  try{
                    $timeStamp= date("Y-m-d H:i:s");
                    $dataModel=new AddressModel;
                    
                    $dataModel->user_id = $request->user_id ;
                    $dataModel->name = $request->name;
                    $dataModel->s_phone  = $request->s_phone;
                    $dataModel->landmark = $request->landmark;
                    $dataModel->area  = $request->area;
                    $dataModel->city  = $request->city;
                    if(isset($request->lat)){
                      $dataModel->lat  = $request->lat;
                    }
                    if(isset($request->lng)){
                      $dataModel->lng  = $request->lng;
                    }
      
                    $dataModel->pincode = $request->pincode;
                    if(isset($request->flat_no)){
                        $dataModel->flat_no = $request->flat_no;
                      
                    }
                    if(isset($request->apartment_name)){
                        $dataModel->apartment_name  = $request->apartment_name;
                      
                    }
                  
                 
                    $dataModel->created_at=$timeStamp;
                    $dataModel->updated_at=$timeStamp;
                    $qResponce= $dataModel->save();
                       if($qResponce){
                    
                       $response = [
                             "response"=>200,
                             'status'=>true,
                             'message' => "successfully",
                             "id"=>$dataModel->id
                   
                         ];
                        }else 
                         $response = [
                           "response"=>201,
                           'status'=>false,
                           'message' => "error",
                 
                       ];
                       return response($response, 200);
                               
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                
            
      
       }
       
      }
}
