<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\CartModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;



class CartController extends Controller
{
    function updateQty(Request $request){
      
        $initialCheck=false;
        $validator = Validator::make(request()->all(), [
          'id'=>'required',
          'qty'=>'required',
          'total_price'=>'required'
      ]);
      if ($validator->fails())
      $initialCheck=true;
        if ($initialCheck)
            return response (["response"=>400],400);
              else{
               try{
                  $dataModel= CartModel::where("id",$request->id)->first();
                  $dataModel->qty=$request->qty;
                  $dataModel->total_price=$request->total_price;
                  
             $qResponce= $dataModel->save();
              if($qResponce)
                $response = [
                    "response"=>200,
                    'status'=>true,
                    'message' => "successfully",
          
                ];else 
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "error",
        
              ];
              return response($response, 200);
                }
                catch(\Exception $e){
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error",
                ];
                return response($response, 200);
                }
          
                   
              }
           
          
    }
  
    function getDataByUId($id)
    {
  
      $data = DB::table("cart")
      ->select('cart.*',
       'product.title',
            'images.image as product_image',
       'product.qty_text',
          'product.stock_qty'
    
      )
           ->leftJoin('images', function ($join) {
         $join->on('images.table_id', '=', 'cart.product_id')
         ->where('images.table_name','=',"product")
         ->where('images.image_type','=',1);
         })
       ->Join('product','cart.product_id', '=','product.id')
       ->where("cart.user_id","=",$id)
       ->orderBy('cart.created_at','DESC')
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function deleteData(Request $request){
      
        $initialCheck=false;
        $validator = Validator::make(request()->all(), [
          'id'=>'required'
      ]);
      if ($validator->fails())
      $initialCheck=true;
      
        
        if ($initialCheck)
            return response (["response"=>400],400);
              else{
               try{
                  $timeStamp= date("Y-m-d H:i:s");
                  $dataModel= CartModel::where("id",$request->id)->first();
              
                               
             $qResponce= $dataModel->delete();
              if($qResponce)
                $response = [
                    "response"=>200,
                    'status'=>true,
                    'message' => "successfully",
          
                ];else 
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "error",
        
              ];
              return response($response, 200);
            
            
           
                }
                catch(\Exception $e){
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error",
                ];
                return response($response, 200);
                }
          
                   
              }
           
          
    }
    function addData(Request $request)
    {
           
        $validator = Validator::make(request()->all(), [
            'product_id' => 'required',
            'user_id' => 'required',
            'qty' => 'required',
            'price' => 'required',
            'mrp' => 'required',
            'total_price' => 'required',
            'tax' => 'required',
            'qty_text' => 'required'
            
    ]);
  
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
                  try{

                    $alreadyExists = CartModel::where('user_id', '=', $request->user_id)->where('product_id',"=",$request->product_id)->first();
               if ($alreadyExists == null){
                $timeStamp= date("Y-m-d H:i:s");
                $dataModel=new CartModel;
                
                $dataModel->user_id = $request->user_id;
                $dataModel->product_id = $request->product_id;
               
                $dataModel->qty  = $request->qty;
                $dataModel->price = $request->price;
                $dataModel->mrp  = $request->mrp;
                $dataModel->tax = $request->tax;
                $dataModel->qty_text = $request->qty_text;
                $dataModel->total_price = $request->total_price;
                
                $dataModel->created_at=$timeStamp;
                $dataModel->updated_at=$timeStamp;
                $qResponce= $dataModel->save();
                   if($qResponce){
                
                   $response = [
                         "response"=>200,
                         'status'=>true,
                         'message' => "successfully",
                         "id"=>$dataModel->id
               
                     ];
                    }else 
                     $response = [
                       "response"=>201,
                       'status'=>false,
                       'message' => "error",
             
                   ];
                   return response($response, 200);
               }
               else {
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "already exists in cart"];
                  return response($response, 200);
              }
                                      
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                
            
      
       }
       
      }
}
