<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class LoginController extends Controller
{
    function checkUserRegMobile(Request $request)
    {
        $validator = Validator::make(request()->all(), [
            'phone' => 'required'
      ]);
          
      if ($validator->fails())
        return response (["response"=>400],400);
        
        $user= User::where('phone', $request->phone)->first();

            if (!$user) {
                return response([
                    "response"=>201,
                    "status"=>false,
                    'message' => 'These credentials do not match our records.'
                ], 200);
            }else{
                return response([
                    "response"=>201,
                    "status"=>true,
                    'message' => 'User exists'
                ], 200);
            }
      
    
    }
    function loginMobile(Request $request)
    {
        $validator = Validator::make(request()->all(), [
            'phone' => 'required'
      ]);
          
      if ($validator->fails())
        return response (["response"=>400],400);

        $user= User::where('phone', $request->phone)->first();
    
            if (!$user) {
                return response([
                    "response"=>200,
                    "status"=>false,
                    'message' => 'These credentials do not match our records. please register',
                    'data' => null,
                    
                ], 200);
            }
      
             $token = $user->createToken('my-app-token')->plainTextToken;
     
        $user->role = DB::table("assign_role")
        ->select(
            'assign_role.id',
        'role.id as role_id' ,
        'role.title as role_title',
        )
        ->Join('role','role.id','=','assign_role.role_id')
        ->where('assign_role.user_id', '=', $user->id)
        ->get();
     
            $response = [
                "response"=>200,
                "status"=>true,
                'message' => "Successfully",
                'data' => $user,
                'token' => $token,
            ];
        
             return response($response, 200);
    }
    function login(Request $request)
    {
        $user= User::where('email', $request->email)->first();
    
            if (!$user || !Hash::check($request->password, $user->password)) {
                return response([
                    "response"=>201,
                    "status"=>false,
                    'message' => 'These credentials do not match our records.'
                ], 200);
            }
      
             $token = $user->createToken('my-app-token')->plainTextToken;
     
        $user->role = DB::table("assign_role")
        ->select(
            'assign_role.id',
        'role.id as role_id' ,
        'role.title as role_title',
        )
        ->Join('role','role.id','=','assign_role.role_id')
        ->where('assign_role.user_id', '=', $user->id)
        ->get();
     
            $response = [
                "response"=>200,
                "status"=>true,
                'message' => "Successfully",
                'data' => $user,
                'token' => $token,
            ];
        
             return response($response, 200);
    }
  
}
