<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ProductModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use App\Models\ImageModel;


class ProductController extends Controller
{
  function deleteImage(Request $request){
      
    $initialCheck=false;
    $validator = Validator::make(request()->all(), [
      'id'=>'required'
  ]);
  if ($validator->fails())
  $initialCheck=true;
  
    if ($initialCheck)
        return response (["response"=>400],400);
          else{
           try{
              $timeStamp= date("Y-m-d H:i:s");
              $dataModel= ImageModel::where("id",$request->id)->first();
                           
         $qResponce= $dataModel->delete();
          if($qResponce)
            $response = [
                "response"=>200,
                'status'=>true,
                'message' => "successfully",
      
            ];else 
            $response = [
              "response"=>201,
              'status'=>false,
              'message' => "error",
    
          ];
          return response($response, 200);
            }
            catch(\Exception $e){
              $response = [
                "response"=>201,
                'status'=>false,
                'message' => "error",
            ];
            return response($response, 200);
            }
      
               
          }
       
      
}
  function uploadImage(Request $request){
    $validator = Validator::make(request()->all(), [
      'image' => 'required',
      'id' => 'required',
      'image_type' => 'required'
]);
    
   if ($validator->fails())
    return response (["response"=>400],400);
      else
         {
           $alreadyExists=null;
          if($request->image_type==1){
            $alreadyExists = ImageModel::where('table_id', '=', $request->id)->where('table_name',"=","product")->where('image_type',"=","1")->first();
          }
      
  
    
     if ($alreadyExists == null)
        {
             try{
              
                    $image=$request->image;
                    $newName=rand().'.'.$image->getClientOriginalExtension();
                    $image->move(public_path('/uploads/images'),$newName);
                    $timeStamp= date("Y-m-d H:i:s");
                    $dataModel=new ImageModel;
                    $dataModel->table_name= "product";
                    $dataModel->table_id= $request->id;
                    $dataModel->image_type= $request->image_type;
                    $dataModel->image= $newName;
                    $dataModel->created_at=$timeStamp;
                    $dataModel->updated_at=$timeStamp;
                    $qResponce= $dataModel->save();
                       if($qResponce){
       
                       $response = [
                             "response"=>200,
                             'status'=>true,
                             'file'=>$newName,
                             'message' => "successfully"
                   
                         ];
                        }else 
                         $response = [
                           "response"=>201,
                           'status'=>false,
                           'message' => "error",
                 
                       ];
                       return response($response, 200);
                               
                  }catch(\Exception $e){
            
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error $e",
              
                  ];
                  return response($response, 200);
                  }
                }  else {
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "image already exists"];
                    return response($response, 200);
                }
        
        
            }
        
    }

    function deleteData(Request $request){
      
        $initialCheck=false;
        $validator = Validator::make(request()->all(), [
          'id'=>'required'
      ]);
      if ($validator->fails())
      $initialCheck=true;
      
        
        if ($initialCheck)
            return response (["response"=>400],400);
              else{
               try{
                  $timeStamp= date("Y-m-d H:i:s");
                  $dataModel= ProductModel::where("id",$request->id)->first();
              
                               
             $qResponce= $dataModel->delete();
              if($qResponce)
                $response = [
                    "response"=>200,
                    'status'=>true,
                    'message' => "successfully",
          
                ];else 
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "error",
        
              ];
              return response($response, 200);
            
          
           
                }
                catch(\Exception $e){
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error",
                ];
                return response($response, 200);
                }
          
                   
              }
           
          
    }
    function getDataById($id)
    {

      $data = DB::table("product")
      ->select('product.*',
      'sub_cat.title as sub_cat_title',
      'cat.id as cat_id',
      'cat.title as cat_title',
      'images.id as image_id',
      'images.image'  
      )
      ->leftJoin('images', function ($join) {
        $join->on('images.table_id', '=', 'product.id')
        ->where('images.table_name','=',"product")
        ->where('images.image_type','=',1);
        })
       ->join('sub_cat','sub_cat.id','=','product.sub_cat_id')
       ->join('cat','cat.id','=','sub_cat.cat_id')
       ->where("product.id","=",$id)
        ->first();
        if( $data!=null){
          $data->slider_image=DB::table("images")
          ->select('images.id',
          'images.image'
          )
          ->where("images.table_id","=",$id)
          ->where("images.table_name","=","product")
          ->where('images.image_type','=',2)
          ->get();
        }

      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function getDataBySubCatId($id)
    {

      $data = DB::table("product")
      ->select('product.*',
      'sub_cat.title as sub_cat_title',
      'cat.id as cat_id',
      'cat.title as cat_title',
      'images.id as image_id',
      'images.image'  
      )
      ->leftJoin('images', function ($join) {
        $join->on('images.table_id', '=', 'product.id')
        ->where('images.table_name','=',"product")
        ->where('images.image_type','=',1);
        })
       ->join('sub_cat','sub_cat.id','=','product.sub_cat_id')
       ->join('cat','cat.id','=','sub_cat.cat_id')
       ->where("product.sub_cat_id","=",$id)
       ->orderBy('product.created_at','ASC')
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function getData()
    {

      $data = DB::table("product")
      ->select('product.*',
      'sub_cat.title as sub_cat_title',
      'cat.id as cat_id',
      'cat.title as cat_title',
      'images.id as image_id',
      'images.image'  
      )
      ->leftJoin('images', function ($join) {
        $join->on('images.table_id', '=', 'product.id')
        ->where('images.table_name','=',"product")
        ->where('images.image_type','=',1);
        })
       ->join('sub_cat','sub_cat.id','=','product.sub_cat_id')
       ->join('cat','cat.id','=','sub_cat.cat_id')
 
       ->orderBy('product.created_at','ASC')
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function updateDetails(Request $request){
        $initialCheck=false;
        $validator = Validator::make(request()->all(), [
          'id'=>'required'
      ]);
      if ($validator->fails())
      $initialCheck=true;
      
        
        if ($initialCheck)
            return response (["response"=>400],400);
              else{
               try{
                  $timeStamp= date("Y-m-d H:i:s");
                    $dataModel= ProductModel::where("id",$request->id)->first();
                    $alreadyExists = ProductModel::where('title', '=', $request->title)->where('id',"!=",$request->id)->first();
                  
  
               if ($alreadyExists == null)
                  {
              
                  if(isset($request->title)){
                    $dataModel->title  = $request->title;
                }
                if(isset($request->qty_text)){
                  $dataModel->qty_text = $request->qty_text;
              }
              if(isset($request->sub_cat_id)){
                $dataModel->sub_cat_id  = $request->sub_cat_id;
            }
            if(isset($request->stock_qty)){
              $dataModel->stock_qty  = $request->stock_qty;
          }
           
            if(isset($request->price)){
              $dataModel->price = $request->price;
          }
          if(isset($request->mrp)){
            $dataModel->mrp  = $request->mrp;
        }
        if(isset($request->subscription)){
          $dataModel->subscription  = $request->subscription;
      }
      if(isset($request->tax)){
        $dataModel->tax  = $request->tax;
    }
   
                             
                  if(isset($request->offer_text)){
                      $dataModel->offer_text = $request->offer_text;
                  }
                  if(isset($request->description)){
                      $dataModel->description  = $request->description;
                  }
                  if(isset($request->disclaimer)){
                  $dataModel->disclaimer = $request->disclaimer;
                  }   
           
                     $dataModel->updated_at=$timeStamp;
                
               
             $qResponce= $dataModel->save();
       
              if($qResponce)
           {   
      
            // $imageFile=isset($request->image)?$request->image:null;
            // $imageId=isset($request->image_id)?$request->image_id:null;
         
            // app('App\Http\Controllers\ImageCountController')->uploadImage($imageFile, "buses", $userDetailsModel->id,1,$imageId);
            // //1=profile_image  
            
            $response = [
                    "response"=>200,
                    'status'=>true,
                    'message' => "successfully",
          
                ];}
                else 
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "error",
        
              ];
              return response($response, 200);
                 }
                 else {
                   $response = [
                     "response"=>201,
                     'status'=>false,
                     'message' => "title already exists"];
                     return response($response, 200);
                 }
         
            
           
                }
                catch(\Exception $e){
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error $e",
                ];
                return response($response, 200);
                }
          
                   
              } 
              
        
        
          }
    function addData(Request $request)
    {
        
        $validator = Validator::make(request()->all(), [
            'sub_cat_id' => 'required',
            'title' => 'required',
            'qty_text' => 'required',
            'price' => 'required',
            'mrp' => 'required',
            'subscription' => 'required',
            'stock_qty' => 'required',
            'tax' => 'required'
            
    ]);
        
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
        
               $alreadyExists = ProductModel::where('title', '=', $request->title)->first();
                if ($alreadyExists === null) {
                  try{
                    $timeStamp= date("Y-m-d H:i:s");
                    $dataModel=new ProductModel;
                    $dataModel->title  = $request->title;
                    $dataModel->qty_text = $request->qty_text;
                    $dataModel->sub_cat_id  = $request->sub_cat_id;
                    $dataModel->price = $request->price;
                    $dataModel->mrp  = $request->mrp;
                    $dataModel->stock_qty  = $request->stock_qty;
                    $dataModel->tax  = $request->tax;
                    $dataModel->subscription  = $request->subscription;
                    if(isset($request->offer_text)){
                        $dataModel->offer_text = $request->offer_text;
                    }
                    if(isset($request->description)){
                        $dataModel->description  = $request->description;
                    }
                    if(isset($request->disclaimer)){
                    $dataModel->disclaimer = $request->disclaimer;
                    }              
                
                    $dataModel->created_at=$timeStamp;
                    $dataModel->updated_at=$timeStamp;
                    $qResponce= $dataModel->save();
                       if($qResponce){
                      //   if(isset($request->image)){
                      //     if($request->hasFile('image'))
                      //     app('App\Http\Controllers\ImageCountController')->uploadImage($request->image, "cat", $dataModel->id,1,null);
                      //  //1=profile_image
                      //   }
                       $response = [
                             "response"=>200,
                             'status'=>true,
                             'message' => "successfully",
                             "id"=> $dataModel->id
                   
                         ];
                        }else 
                         $response = [
                           "response"=>201,
                           'status'=>false,
                           'message' => "error",
                 
                       ];
                       return response($response, 200);
                               
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                }
                
                else {
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "title already exists"];
                    return response($response, 200);
                }
      
       }
       
      }
}
