<?php

namespace App\Http\Controllers;
use App\Models\AllowPincodeModel;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

use Illuminate\Http\Request;

class ReportController extends Controller
{
   

    function getDataAllDeliveryReport()
    {

      $data = DB::table("subscribed_order_delivery")
      ->select('subscribed_order_delivery.*',
      'users.name',
      'user_address.pincode',
      'user_address.s_phone',
      'product.qty_text',
      'product.title',
      'orders.subscription_type',
      'orders.order_type',
      'orders.order_amount',
      'orders.qty',
      'orders.selected_days_for_weekly',
      'orders.subscription_type'
      )
      ->Join('users','users.id', '=','subscribed_order_delivery.entry_user_id')
      ->Join('orders','orders.id', '=','subscribed_order_delivery.order_id')
      ->Join('product','product.id', '=','orders.product_id')
      ->Join('user_address','user_address.id', '=','orders.address_id')
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function getDataAllDeliveryByUser($userId)
    {

      $data = DB::table("subscribed_order_delivery")
      ->select('subscribed_order_delivery.*',
      'users.name',
      'user_address.pincode',
      'user_address.s_phone',
      'product.qty_text',
      'product.title',
      'orders.subscription_type',
      'orders.order_type',
      'orders.order_amount',
      'orders.qty',
      'orders.selected_days_for_weekly',
      'orders.subscription_type'
      )
      ->Join('users','users.id', '=','subscribed_order_delivery.entry_user_id')
      ->Join('orders','orders.id', '=','subscribed_order_delivery.order_id')
      ->Join('product','product.id', '=','orders.product_id')
      ->Join('user_address','user_address.id', '=','orders.address_id')
      ->where('subscribed_order_delivery.entry_user_id','=',$userId)
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    
    function getDataAllDeliveryReportByDate($firstDate,$lastDate)
    {

      $data = DB::table("subscribed_order_delivery")
      ->select('subscribed_order_delivery.*',
      'users.name',
      'user_address.pincode',
      'user_address.s_phone',
      'product.qty_text',
      'product.title',
      'orders.subscription_type',
      'orders.order_type',
      'orders.order_amount',
      'orders.qty',
      'orders.selected_days_for_weekly',
      'orders.subscription_type'
      )
      ->Join('users','users.id', '=','subscribed_order_delivery.entry_user_id')
      ->Join('orders','orders.id', '=','subscribed_order_delivery.order_id')
      ->Join('product','product.id', '=','orders.product_id')
      ->Join('user_address','user_address.id', '=','orders.address_id')
      ->where('subscribed_order_delivery.date','>=',$firstDate)
      ->where('subscribed_order_delivery.date','<=',$lastDate)
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }
    function getDataAllDeliveryReportByDateAndUser($userId,$firstDate,$lastDate)
    {

      $data = DB::table("subscribed_order_delivery")
      ->select('subscribed_order_delivery.*',
      'users.name',
      'user_address.pincode',
      'user_address.s_phone',
      'product.qty_text',
      'product.title',
      'orders.subscription_type',
      'orders.order_type',
      'orders.order_amount',
      'orders.qty',
      'orders.selected_days_for_weekly',
      'orders.subscription_type'
      )
      ->Join('users','users.id', '=','subscribed_order_delivery.entry_user_id')
      ->Join('orders','orders.id', '=','subscribed_order_delivery.order_id')
      ->Join('product','product.id', '=','orders.product_id')
      ->Join('user_address','user_address.id', '=','orders.address_id')
      ->where('subscribed_order_delivery.entry_user_id','=',$userId)
      ->where('subscribed_order_delivery.date','>=',$firstDate)
      ->where('subscribed_order_delivery.date','<=',$lastDate)
        ->get();
      
            $response = [
                "response"=>200,
                'data'=>$data,
            ];
        
      return response($response, 200);
    }

 
}
