<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use App\Models\WebAppSettingsModel;
class SendNotificationController extends Controller
{



  function sendFirebaseNotificationToLowWallet($title,$body,$imageUrl,$token){
              
          $dataModel= WebAppSettingsModel::where("id",10)->first();
        
  if(isset($dataModel->value)){
      $sendData=[
        "to"=>"$token", 
          "notification"=> [
            "sound"=> "default",
            "body" =>$body,
            "title"=> $title,
            "content_available"=> true,
            "priority"=> "high",
            "image"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:"",
          ],
          "data"=> [
            "is_specific"=>true,
            "sound"=> "default",
            "body" =>$body,
            "title"=> $title,
            "content_available"=> true,
            "priority"=> "high",
            "imageUrl"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:""
          ]
        ];
    $sendResponse = Http::withHeaders([
        'Authorization' => 'key='.$dataModel->value 
    ])->post('https://fcm.googleapis.com/fcm/send', $sendData);
  
    $response = [
        "response"=>$sendResponse->status(),
        "message"=>$sendResponse->body(),
    ];

 return $response;
    
    }
      else{
               $response = [
              "response"=>201,
              'status'=>false,
              'message' => "error",
    
          ];
          return $response;
      }


}

  function sendFirebaseNotificationToToken($title,$body,$imageUrl,$token){
    $dataModel= WebAppSettingsModel::where("id",10)->first();
        
    if(isset($dataModel->value)){
      $sendData=[
        "to"=>"$token", 
          "notification"=> [
            "sound"=> "default",
            "body" =>$body,
            "title"=> $title,
            "content_available"=> true,
            "priority"=> "high",
            "image"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:"",
          ],
          "data"=> [
            "sound"=> "default",
            "body" =>$body,
            "title"=> $title,
            "content_available"=> true,
            "priority"=> "high",
            "imageUrl"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:""
          ]
        ];
    $sendResponse = Http::withHeaders([
        'Authorization' => 'key='.$dataModel->value 
    ])->post('https://fcm.googleapis.com/fcm/send', $sendData);
  
    $response = [
        "response"=>$sendResponse->status(),
        "message"=>$sendResponse->body(),
    ];

 return $response;
      
      
      }
        else{
                 $response = [
                "response"=>201,
                'status'=>false,
                'message' => "error",
      
            ];
            return $response;
            
        }


}
    function sendFirebaseNotificationToTopic($title,$body,$imageUrl,$topic){
      $dataModel= WebAppSettingsModel::where("id",10)->first();
        
      if(isset($dataModel->value)){
            $sendData=[
            "to"=>"/topics/$topic", 
              "notification"=> [
                "sound"=> "default",
                "body" =>$body,
                "title"=> $title,
                "content_available"=> true,
                "priority"=> "high",
                "image"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:"",
              ],
              "data"=> [
                "sound"=> "default",
                "body" =>$body,
                "title"=> $title,
                "content_available"=> true,
                "priority"=> "high",
                "imageUrl"=> $imageUrl!=null&&$imageUrl!=""?$imageUrl:""
              ]
            ];
        $sendResponse = Http::withHeaders([
            'Authorization' => 'key='.$dataModel->value 
        ])->post('https://fcm.googleapis.com/fcm/send', $sendData);
      
        $response = [
            "response"=>$sendResponse->status(),
            "message"=>$sendResponse->body(),
        ];
    
     return $response;
        
        
        }
          else{
                   $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "error",
        
              ];
              return $response;
              
          }

   

    }
    
   function sendReqFirebaseNotificationToTopic(Request $request)
   {
    $validator = Validator::make(request()->all(), [
        'title' => 'required',
        'body'=>'required',
        "topic"=>'required'
  ]);
      
  if ($validator->fails()){
    return response (["response"=>400],400);
}
    else{
        $sendResponse = $this-> sendFirebaseNotificationToTopic($request->title,$request->body,$request->image_Url,$request->topic);
     
    
  return response($sendResponse, 200);
    }
}
function sendReqFirebaseNotificationToToken(Request $request)
{
 $validator = Validator::make(request()->all(), [
     'title' => 'required',
     'body'=>'required',
     "token"=>'required'
]);
   
if ($validator->fails()){
 return response (["response"=>400],400);
}
 else{
     $sendResponse = $this-> sendFirebaseNotificationToToken($request->title,$request->body,$request->image_Url,$request->token);
  
 
return response($sendResponse, 200);
 }
}
  }