<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SubOderDeliveyModel;
use App\Models\User;
use App\Models\TransactionsModel;
use App\Models\OrderModel;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
//

class SubOrderDeliveyController extends Controller
{
  function getDataByOrderId($id)
  {

    $data = DB::table("subscribed_order_delivery")
    ->select('subscribed_order_delivery.*',
    'users.email',
    'users.phone',
    'users.name'
     )
     ->where("subscribed_order_delivery.order_id","=",$id)
     ->Join('users','users.id', '=','subscribed_order_delivery.entry_user_id')
     ->orderBy('subscribed_order_delivery.date','DESC')
      ->get();
    
          $response = [
              "response"=>200,
              'data'=>$data,
          ];
      
    return response($response, 200);
  }
    function addDataWeekely(Request $request)
  {
      
      $validator = Validator::make(request()->all(), [
        'entry_user_id' => 'required',
        'order_id' => 'required',
        'qty' => 'required'
  ]);
      
  if ($validator->fails())
    return response (["response"=>400],400);
      else{
          $todayDate= date("Y-m-d");
             $alreadyExists =SubOderDeliveyModel::where('order_id', '=', $request->order_id)->where('date', '=', $todayDate)->first();
              if ($alreadyExists === null) {
            
                try{
                  $orderData = DB::table("orders")
                  ->select('orders.user_id',
                 'orders.order_amount',
                 'orders.order_type',
                 'users.wallet_amount',
                 'product.title'
                   )
                   ->where("orders.id","=",$request->order_id)
                   ->Join('users','users.id', '=','orders.user_id')
                   ->Join('product','orders.product_id', '=','product.id')
                    ->first();
                    // echo  $orderData->wallet_amount;
                    if($orderData->order_type==1){
                      if( $orderData->wallet_amount==null){
                        $response = [
                          "response"=>201,
                          'status'=>false,
                          'message' => "No amount in user wallet",
                  
                      ];
                      return response($response, 200);
                  
                      } else if($orderData->wallet_amount!=null){
                     
                        if($orderData->wallet_amount==0){
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "No amount in user wallet",
                    
                        ];
                        return response($response, 200);
                        }
                        else{
                          $dataModelUser= User::where("id",$orderData->user_id)->first();
                          $oldAmount=$dataModelUser->wallet_amount;
                          $finalOrderAmount=($orderData->order_amount)*($request->qty);
                          $checkAmount=$oldAmount-$finalOrderAmount;

                          if($oldAmount>=$finalOrderAmount){
                              $newAmount=$oldAmount-$finalOrderAmount;
                              $dataModelUser->wallet_amount  = $newAmount;
                              $dataModelUser->save();
                         
                               $timeStamp= date("Y-m-d H:i:s");
                                        $dataModel=new SubOderDeliveyModel;
                                        $dataModel->order_id = $request->order_id;
                                        $dataModel->entry_user_id = $request->entry_user_id;
                                        $dataModel->date=$todayDate;
                                        $dataModel->payment_mode = 1;
                                        $dataModel->created_at=$timeStamp;
                                        $dataModel->updated_at=$timeStamp;
                                        $qResponce= $dataModel->save();
                                          if($qResponce){
                                            $timeStamp= date("Y-m-d H:i:s");
                                            $dataModelTxn=new TransactionsModel;
                                            $dataModelTxn->user_id  = $orderData->user_id;
                                            $dataModelTxn->order_id   = $request->order_id;
                                            $dataModelTxn->amount = $finalOrderAmount;
                                            $dataModelTxn->type  = 2;
                                            $productName=$orderData->title;
                                            $dataModelTxn->description  = "Amount debited from wallet - $productName";
                                    
                                            $dataModelTxn->created_at=$timeStamp;
                                            $dataModelTxn->updated_at=$timeStamp;
                                    
                                            $qResponce= $dataModelTxn->save();
                                          $response = [
                                                "response"=>200,
                                                'status'=>true,
                                                'message' => "successfully",
                                                'id' => $dataModel->id
                                            ];
                                            }else 
                                            $response = [
                                              "response"=>201,
                                              'status'=>false,
                                              'message' => "error",
                                    
                                          ];
                                          return response($response, 200);


                            
                          }else{
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "Less wallet amount",
                      
                          ];
                          return response($response, 200);
                          }

                        }
                      }
                        
                    }else  if($orderData->order_type==2){
                      $timeStamp= date("Y-m-d H:i:s");
                      $dataModel=new SubOderDeliveyModel;
                      $dataModel->order_id = $request->order_id;
                      $dataModel->entry_user_id = $request->entry_user_id;
                      $dataModel->date=$todayDate;
                      $dataModel->created_at=$timeStamp;
                      $dataModel->updated_at=$timeStamp;
                      $qResponce= $dataModel->save();
                        if($qResponce){
                         
                        $response = [
                              "response"=>200,
                              'status'=>true,
                              'message' => "successfully",
                              'id' => $dataModel->id
                          ];
                          }else 
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "error",
                  
                        ];
                        return response($response, 200);
                    }else{
                      $response = [
                        "response"=>201,
                        'status'=>false,
                        'message' => "error",
                
                    ];
                    return response($response, 200);
                    }
                                              
                }catch(\Exception $e){
            
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error",
            
                ];
                return response($response, 200);
                }
              }
              
              else {
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "Today delivery is already done for this order"];
                  return response($response, 200);
              }
    
     }
     
    }
  function addDataWeekelyManually(Request $request)
  {
      
      $validator = Validator::make(request()->all(), [
        'entry_user_id' => 'required',
        'order_id' => 'required',
        'qty' => 'required',
         'date' => 'required'
  ]);
      
  if ($validator->fails())
    return response (["response"=>400],400);
      else{
          $todayDate= $request->date;
             $alreadyExists =SubOderDeliveyModel::where('order_id', '=', $request->order_id)->where('date', '=', $todayDate)->first();
              if ($alreadyExists === null) {
                    //       $response = [
                    //             "response"=>200,
                    //             'status'=>true,
                    //             'message' => "successfullx"
                          
                    //         ];
                    //   return response($response, 200);
            
                try{
                  $orderData = DB::table("orders")
                  ->select('orders.user_id',
                 'orders.order_amount',
                 'orders.order_type',
                 'users.wallet_amount',
                 'product.title'
                  )
                  ->where("orders.id","=",$request->order_id)
                  ->Join('users','users.id', '=','orders.user_id')
                  ->Join('product','orders.product_id', '=','product.id')
                    ->first();
                    // echo  $orderData->wallet_amount;
                    if($orderData->order_type==1){
                      if( $orderData->wallet_amount==null){
                        $response = [
                          "response"=>201,
                          'status'=>false,
                          'message' => "No amount in user wallet",
                  
                      ];
                      return response($response, 200);
                  
                      } else if($orderData->wallet_amount!=null){
                     
                        if($orderData->wallet_amount==0){
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "No amount in user wallet",
                    
                        ];
                        return response($response, 200);
                        }
                        else{
                          $dataModelUser= User::where("id",$orderData->user_id)->first();
                          $oldAmount=$dataModelUser->wallet_amount;
                          $finalOrderAmount=($orderData->order_amount)*($request->qty);
                          $checkAmount=$oldAmount-$finalOrderAmount;

                          if($oldAmount>=$finalOrderAmount){
                              $newAmount=$oldAmount-$finalOrderAmount;
                              $dataModelUser->wallet_amount  = $newAmount;
                              $dataModelUser->save();
                         
                              $timeStamp= date("Y-m-d H:i:s");
                                        $dataModel=new SubOderDeliveyModel;
                                        $dataModel->order_id = $request->order_id;
                                        $dataModel->entry_user_id = $request->entry_user_id;
                                        $dataModel->date=$todayDate;
                                        $dataModel->payment_mode = 1;
                                        $dataModel->created_at=$timeStamp;
                                        $dataModel->updated_at=$timeStamp;
                                        $qResponce= $dataModel->save();
                                          if($qResponce){
                                            $timeStamp= date("Y-m-d H:i:s");
                                            $dataModelTxn=new TransactionsModel;
                                            $dataModelTxn->user_id  = $orderData->user_id;
                                            $dataModelTxn->order_id   = $request->order_id;
                                            $dataModelTxn->amount = $finalOrderAmount;
                                            $dataModelTxn->type  = 2;
                                            $productName=$orderData->title;
                                            $dataModelTxn->description  = "Amount debited from wallet - $productName";
                                    
                                            $dataModelTxn->created_at=$timeStamp;
                                            $dataModelTxn->updated_at=$timeStamp;
                                    
                                            $qResponce= $dataModelTxn->save();
                                          $response = [
                                                "response"=>200,
                                                'status'=>true,
                                                'message' => "successfully",
                                                'id' => $dataModel->id
                                            ];
                                            }else 
                                            $response = [
                                              "response"=>201,
                                              'status'=>false,
                                              'message' => "error",
                                    
                                          ];
                                          return response($response, 200);


                            
                          }else{
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "Less wallet amount",
                      
                          ];
                          return response($response, 200);
                          }

                        }
                      }
                        
                    }else  if($orderData->order_type==2){
                      $timeStamp= date("Y-m-d H:i:s");
                      $dataModel=new SubOderDeliveyModel;
                      $dataModel->order_id = $request->order_id;
                      $dataModel->entry_user_id = $request->entry_user_id;
                      $dataModel->date=$todayDate;
                      $dataModel->created_at=$timeStamp;
                      $dataModel->updated_at=$timeStamp;
                      $qResponce= $dataModel->save();
                        if($qResponce){
                         
                        $response = [
                              "response"=>200,
                              'status'=>true,
                              'message' => "successfully",
                              'id' => $dataModel->id
                          ];
                          }else 
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "error",
                  
                        ];
                        return response($response, 200);
                    }else{
                      $response = [
                        "response"=>201,
                        'status'=>false,
                        'message' => "error",
                
                    ];
                    return response($response, 200);
                    }
                                              
                }catch(\Exception $e){
            
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "error",
            
                ];
                return response($response, 200);
                }
              }
              
              else {
                $response = [
                  "response"=>201,
                  'status'=>false,
                  'message' => "Today delivery is already done for this order"];
                  return response($response, 200);
              }
    
     }
     
    }
        function addData(Request $request)
    {
        
        $validator = Validator::make(request()->all(), [
          'entry_user_id' => 'required',
          'order_id' => 'required'
    ]);
        
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
            $todayDate= date("Y-m-d");
               $alreadyExists =SubOderDeliveyModel::where('order_id', '=', $request->order_id)->where('date', '=', $todayDate)->first();
                if ($alreadyExists === null) {
              
                  try{
                    $orderData = DB::table("orders")
                    ->select('orders.user_id',
                   'orders.order_amount',
                   'orders.order_type',
                   'users.wallet_amount',
                   'product.title'
                     )
                     ->where("orders.id","=",$request->order_id)
                     ->Join('users','users.id', '=','orders.user_id')
                     ->Join('product','orders.product_id', '=','product.id')
                      ->first();
                      // echo  $orderData->wallet_amount;
                      if($orderData->order_type==1){
                        if( $orderData->wallet_amount==null){
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "No amount in user wallet",
                    
                        ];
                        return response($response, 200);
                    
                        } else if($orderData->wallet_amount!=null){
                       
                          if($orderData->wallet_amount==0){
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "No amount in user wallet",
                      
                          ];
                          return response($response, 200);
                          }
                          else{
                            $dataModelUser= User::where("id",$orderData->user_id)->first();
                            $oldAmount=$dataModelUser->wallet_amount;
                            $checkAmount=$oldAmount-$orderData->order_amount;
  
                            if($oldAmount>=$orderData->order_amount){
                                $newAmount=$oldAmount-$orderData->order_amount;
                                $dataModelUser->wallet_amount  = $newAmount;
                                $dataModelUser->save();
                           
                                 $timeStamp= date("Y-m-d H:i:s");
                                          $dataModel=new SubOderDeliveyModel;
                                          $dataModel->order_id = $request->order_id;
                                          $dataModel->entry_user_id = $request->entry_user_id;
                                          $dataModel->date=$todayDate;
                                          $dataModel->payment_mode = 1;
                                          $dataModel->created_at=$timeStamp;
                                          $dataModel->updated_at=$timeStamp;
                                          $qResponce= $dataModel->save();
                                            if($qResponce){
                                              $timeStamp= date("Y-m-d H:i:s");
                                              $dataModelTxn=new TransactionsModel;
                                              $dataModelTxn->user_id  = $orderData->user_id;
                                              $dataModelTxn->order_id   = $request->order_id;
                                              $dataModelTxn->amount = $orderData->order_amount;
                                              $dataModelTxn->type  = 2;
                                              $productName=$orderData->title;
                                              $dataModelTxn->description  = "Amount debited from wallet - $productName";
                                      
                                              $dataModelTxn->created_at=$timeStamp;
                                              $dataModelTxn->updated_at=$timeStamp;
                                      
                                              $qResponce= $dataModelTxn->save();
                                            $response = [
                                                  "response"=>200,
                                                  'status'=>true,
                                                  'message' => "successfully",
                                                  'id' => $dataModel->id
                                              ];
                                              }else 
                                              $response = [
                                                "response"=>201,
                                                'status'=>false,
                                                'message' => "error",
                                      
                                            ];
                                            return response($response, 200);
  
  
                              
                            }else{
                              $response = [
                                "response"=>201,
                                'status'=>false,
                                'message' => "Less wallet amount",
                        
                            ];
                            return response($response, 200);
                            }
  
                          }
                        }
                          
                      }else  if($orderData->order_type==2){
                        $timeStamp= date("Y-m-d H:i:s");
                        $dataModel=new SubOderDeliveyModel;
                        $dataModel->order_id = $request->order_id;
                        $dataModel->entry_user_id = $request->entry_user_id;
                        $dataModel->date=$todayDate;
                        $dataModel->created_at=$timeStamp;
                        $dataModel->updated_at=$timeStamp;
                        $qResponce= $dataModel->save();
                          if($qResponce){
                           
                          $response = [
                                "response"=>200,
                                'status'=>true,
                                'message' => "successfully",
                                'id' => $dataModel->id
                            ];
                            }else 
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "error",
                    
                          ];
                          return response($response, 200);
                      }else{
                        $response = [
                          "response"=>201,
                          'status'=>false,
                          'message' => "error",
                  
                      ];
                      return response($response, 200);
                      }
                                                
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                }
                
                else {
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "Today delivery is already done for this order"];
                    return response($response, 200);
                }
      
       }
       
      }

    function addDataManually(Request $request)
    {
        
        $validator = Validator::make(request()->all(), [
          'entry_user_id' => 'required',
          'order_id' => 'required',
           'date' => 'required'
    ]);
        
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
            
            $todayDate= $request->date;
               $alreadyExists =SubOderDeliveyModel::where('order_id', '=', $request->order_id)->where('date', '=', $todayDate)->first();
                if ($alreadyExists === null) {
                    //      $response = [
                    //             "response"=>200,
                    //             'status'=>true,
                    //             'message' => "successfullz"
                          
                    //         ];
                    //   return response($response, 200);
              
                  try{
                    $orderData = DB::table("orders")
                    ->select('orders.user_id',
                  'orders.order_amount',
                  'orders.order_type',
                  'users.wallet_amount',
                  'product.title'
                     )
                     ->where("orders.id","=",$request->order_id)
                     ->Join('users','users.id', '=','orders.user_id')
                     ->Join('product','orders.product_id', '=','product.id')
                      ->first();
                      // echo  $orderData->wallet_amount;
                      if($orderData->order_type==1){
                        if( $orderData->wallet_amount==null){
                          $response = [
                            "response"=>201,
                            'status'=>false,
                            'message' => "No amount in user wallet",
                    
                        ];
                        return response($response, 200);
                    
                        } else if($orderData->wallet_amount!=null){
                       
                          if($orderData->wallet_amount==0){
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "No amount in user wallet",
                      
                          ];
                          return response($response, 200);
                          }
                          else{
                            $dataModelUser= User::where("id",$orderData->user_id)->first();
                            $oldAmount=$dataModelUser->wallet_amount;
                            $checkAmount=$oldAmount-$orderData->order_amount;
  
                            if($oldAmount>=$orderData->order_amount){
                                $newAmount=$oldAmount-$orderData->order_amount;
                                $dataModelUser->wallet_amount  = $newAmount;
                                $dataModelUser->save();
                           
                                 $timeStamp= date("Y-m-d H:i:s");
                                          $dataModel=new SubOderDeliveyModel;
                                          $dataModel->order_id = $request->order_id;
                                          $dataModel->entry_user_id = $request->entry_user_id;
                                          $dataModel->date=$todayDate;
                                          $dataModel->payment_mode = 1;
                                          $dataModel->created_at=$timeStamp;
                                          $dataModel->updated_at=$timeStamp;
                                          $qResponce= $dataModel->save();
                                            if($qResponce){
                                              $timeStamp= date("Y-m-d H:i:s");
                                              $dataModelTxn=new TransactionsModel;
                                              $dataModelTxn->user_id  = $orderData->user_id;
                                              $dataModelTxn->order_id   = $request->order_id;
                                              $dataModelTxn->amount = $orderData->order_amount;
                                              $dataModelTxn->type  = 2;
                                              $productName=$orderData->title;
                                              $dataModelTxn->description  = "Amount debited from wallet - $productName";
                                      
                                              $dataModelTxn->created_at=$timeStamp;
                                              $dataModelTxn->updated_at=$timeStamp;
                                      
                                              $qResponce= $dataModelTxn->save();
                                            $response = [
                                                  "response"=>200,
                                                  'status'=>true,
                                                  'message' => "successfully",
                                                  'id' => $dataModel->id
                                              ];
                                              }else 
                                              $response = [
                                                "response"=>201,
                                                'status'=>false,
                                                'message' => "error",
                                      
                                            ];
                                            return response($response, 200);
  
  
                              
                            }else{
                              $response = [
                                "response"=>201,
                                'status'=>false,
                                'message' => "Less wallet amount",
                        
                            ];
                            return response($response, 200);
                            }
  
                          }
                        }
                          
                      }else  if($orderData->order_type==2){
                        $timeStamp= date("Y-m-d H:i:s");
                        $dataModel=new SubOderDeliveyModel;
                        $dataModel->order_id = $request->order_id;
                        $dataModel->entry_user_id = $request->entry_user_id;
                        $dataModel->date=$todayDate;
                        $dataModel->created_at=$timeStamp;
                        $dataModel->updated_at=$timeStamp;
                        $qResponce= $dataModel->save();
                          if($qResponce){
                           
                          $response = [
                                "response"=>200,
                                'status'=>true,
                                'message' => "successfully",
                                'id' => $dataModel->id
                            ];
                            }else 
                            $response = [
                              "response"=>201,
                              'status'=>false,
                              'message' => "error",
                    
                          ];
                          return response($response, 200);
                      }else{
                        $response = [
                          "response"=>201,
                          'status'=>false,
                          'message' => "error",
                  
                      ];
                      return response($response, 200);
                      }
                                                
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                }
                
                else {
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "Today delivery is already done for this order"];
                    return response($response, 200);
                }
      
       }
       
      }


   function addNormalOrderData(Request $request)
    {
        
        $validator = Validator::make(request()->all(), [
          'entry_user_id' => 'required',
          'order_id' => 'required',
          'payment_mode' => 'required'
    ]);
        
    if ($validator->fails())
      return response (["response"=>400],400);
        else{
            $todayDate= date("Y-m-d");
               $alreadyExists =SubOderDeliveyModel::where('order_id', '=', $request->order_id)->first();
                if ($alreadyExists === null) {
              
                  try{                  
                         
                               $timeStamp= date("Y-m-d H:i:s");
                                        $dataModel=new SubOderDeliveyModel;
                                        $dataModel->order_id = $request->order_id;
                                        $dataModel->entry_user_id = $request->entry_user_id;
                                        $dataModel->date=$todayDate;
                                        $dataModel->payment_mode=$request->payment_mode;
                                        $dataModel->created_at=$timeStamp;
                                        $dataModel->updated_at=$timeStamp;
                                        $qResponce= $dataModel->save();
                                          if($qResponce){
                                            $dataOrderModel= OrderModel::where("id",$request->order_id)->first();

                                            if($request->payment_mode==2){
                                              $dataModelTxn=new TransactionsModel;
                                              $dataModelTxn->user_id  = $dataOrderModel->user_id;
                                              $dataModelTxn->amount = $dataOrderModel->order_amount;
                                              $dataModelTxn->type  = 2;
                                              $dataModelTxn->payment_mode = 2;
                                      
                                              $dataModelTxn->description  = "Cash Payment";
                                      
                                              $dataModelTxn->created_at=$timeStamp;
                                              $dataModelTxn->updated_at=$timeStamp;
                                      
                                              $dataModelTxn->save();
                                              $dataOrderModel->trasation_id =$dataModelTxn->id;
                                            }
                                           
                                          
                                            $dataOrderModel->delivery_status=1;
                                            $dataOrderModel->save();

                                             $response = [
                                                "response"=>200,
                                                'status'=>true,
                                                'message' => "successfully",
                                                'id' => $dataModel->id
                                            ];
                                            }else 
                                            $response = [
                                              "response"=>201,
                                              'status'=>false,
                                              'message' => "error",
                                    
                                          ];
                                          return response($response, 200);          
                 
                               
                  }catch(\Exception $e){
              
                    $response = [
                      "response"=>201,
                      'status'=>false,
                      'message' => "error",
              
                  ];
                  return response($response, 200);
                  }
                }
                
                else {
                  $response = [
                    "response"=>201,
                    'status'=>false,
                    'message' => "Product already delivered"];
                    return response($response, 200);
                }
      
       }
       
      }
}
