<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\AddressController;
use App\Http\Controllers\TransactionsController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\BannerImageController;
use App\Http\Controllers\UserHolyDayController;
use App\Http\Controllers\OrderAssignController;
use App\Http\Controllers\SubOrderDeliveyController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\WebPageController;
use App\Http\Controllers\AppSettingController;
use App\Http\Controllers\AllowPincodeController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\UserNotificationController;
use App\Http\Controllers\SendNotificationController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\PaymentGetwayController;
use App\Http\Controllers\WebAppSettingsController;
use App\Http\Controllers\AvailableDeliveryLocationController;
use App\Http\Controllers\SocialMediaController;
use App\Http\Controllers\UploadImageController;
use App\Http\Controllers\SpecificNotificationController;
use App\Http\Controllers\TimeCheckController;
use App\Http\Controllers\InvoiceSettingController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::group(['middleware' => 'auth:sanctum'], function(){
    Route::get("get_check_time",[TimeCheckController::class,'checkTimeAvailability']);


    Route::get("get_user",[UsersController::class,'getData']);
    Route::get("get_user/{id}",[UsersController::class,'getDataById']);
    Route::get("get_user/role/{id}",[UsersController::class,'getDataByRole']);
    Route::post("update_user",[UsersController::class,'updateDetails']);
    Route::post("delete_assign_user",[UsersController::class,'deleteAssignData']);
    Route::post("add_assign_user",[UsersController::class,'addAssignData']);
    
    Route::post("add_cat",[CategoryController::class,'addData']);
    Route::post("update_cat",[CategoryController::class,'updateDetails']);
    Route::get("get_cat",[CategoryController::class,'getData']);
        Route::get("gegt_cat",[CategoryController::class,'getData']);
    
    Route::get("get_cat/{id}",[CategoryController::class,'getDataById']);
    Route::post("delete_cat",[CategoryController::class,'deleteData']);
    Route::post("cat/upload_image",[CategoryController::class,'uploadImage']);
    Route::post("cat/delete_image",[CategoryController::class,'deleteImage']);

    Route::post("add_sub_cat",[SubCategoryController::class,'addData']);
    Route::post("update_sub_cat",[SubCategoryController::class,'updateDetails']);
    Route::get("get_sub_cat",[SubCategoryController::class,'getData']);
    Route::get("get_sub_cat/cat_id/{catId}",[SubCategoryController::class,'getDataByCatId']);
    Route::post("sub_cat/upload_image",[SubCategoryController::class,'uploadImage']);
    Route::post("sub_cat/delete_image",[SubCategoryController::class,'deleteImage']);
    Route::get("get_sub_cat/{catId}",[SubCategoryController::class,'getDataById']);
    
    Route::post("delete_sub_cat",[SubCategoryController::class,'deleteData']);

    Route::post("add_product",[ProductController::class,'addData']);
    Route::post("update_product",[ProductController::class,'updateDetails']);
    Route::get("get_product",[ProductController::class,'getData']);
    Route::post("delete_product",[ProductController::class,'deleteData']);
    Route::get("get_product/sub_cat/{subCatId}",[ProductController::class,'getDataBySubCatId']);
    Route::get("get_product/{id}",[ProductController::class,'getDataById']);
    Route::post("product/upload_image",[ProductController::class,'uploadImage']);
    Route::post("product/delete_image",[ProductController::class,'deleteImage']);
    

    Route::post("add_address",[AddressController::class,'addData']);
    Route::get("address/user/{id}",[AddressController::class,'getDataByUserId']);
    Route::get("address/{id}",[AddressController::class,'getDataById']);

    Route::post("add_txn",[TransactionsController::class,'addData']);
    Route::get("txn/user/{id}",[TransactionsController::class,'getDataByUId']);
    Route::get("txn/order/{id}",[TransactionsController::class,'getDataByOrderId']);
    Route::get("txn/sub_order/{id}",[TransactionsController::class,'getDataBySubOrderId']);
    
    Route::get("txn/{id}",[TransactionsController::class,'getDataById']);
    Route::get("txn",[TransactionsController::class,'getData']);
    Route::post("add_order_txn",[TransactionsController::class,'addDirectData']);
    Route::get("txn/by_date_range/{startDate}/{endDate}",[TransactionsController::class,'getDataByDateRange']);
    

    Route::post("add_order",[OrderController::class,'addData']);
    Route::post("add_order_cart",[OrderController::class,'addCardAndOrderData']);
    
    Route::get("get_order/user/{id}",[OrderController::class,'getDataByUId']);
    Route::get("get_order/{id}",[OrderController::class,'getDataById']);
    Route::get("get_order",[OrderController::class,'getData']);
    Route::post("update_order",[OrderController::class,'updateDetails']);
    Route::post("update_order/txn",[OrderController::class,'updateOrderTxnAndAddNewTxn']);
    
    Route::post("add_cart",[CartController::class,'addData']);
    Route::post("cart/update_qty",[CartController::class,'updateQty']);
    Route::post("cart/delete",[CartController::class,'deleteData']);
    Route::get("get_cart/user/{id}",[CartController::class,'getDataByUId']);
    
    Route::post("upload_banner_image",[BannerImageController::class,'uploadImage']);
    Route::get("get_banner/mobile",[BannerImageController::class,'getMobileImageBanner']);
    Route::post("delete_banner_image",[BannerImageController::class,'deleteData']);

    Route::post("add_user_holiday",[UserHolyDayController::class,'addData']);
    Route::get("get_user_holiday/user/{id}",[UserHolyDayController::class,'getDataByUserId']);
    Route::post("delete_user_holiday",[UserHolyDayController::class,'deleteData']);

    Route::post("add_order_assign",[OrderAssignController::class,'addData']);
    Route::post("order_assign/delete",[OrderAssignController::class,'deleteData']);
    Route::get("get_order/emp_user/{id}",[OrderAssignController::class,'getDataByUId']);
    Route::get("get_normal_order/emp_user/{id}",[OrderAssignController::class,'getNormalDataByUId']);
    Route::get("get_delivered_order/emp_user/{id}",[OrderAssignController::class,'getDeliveryDataByUId']);
    Route::get("get_assign_user_order/order/{id}",[OrderAssignController::class,'getOrderAssignUserByOrderId']);
    Route::get("get_assign_user_order/date/order/{id}",[OrderAssignController::class,'getDataByUIdAndDateDeliveredSub']);
    Route::get("get_assign_user_order/sub/order/{id}",[OrderAssignController::class,'getDataByUIdAndDeliveredSub']);
    Route::get("get_upcoming_delivery/normal",[OrderAssignController::class,'getAllNoramlDelivery']);
    Route::get("get_upcoming_delivery/sub",[OrderAssignController::class,'getAllSubAllDelivery']);
    Route::get("get_upcoming_delivery/sub/assign_user/{id}",[OrderAssignController::class,'getAllSubAllDeliveryByAssignUser']);
    Route::get("get_upcoming_delivery/sub_date/{date}",[OrderAssignController::class,'getAllSubAllDeliveryByDate']);
    Route::get("get_upcoming_delivery/sub_date/assign_user/{id}/{date}",[OrderAssignController::class,'getAllSubAllDeliveryByAssignUserByDate']);

    
    
    Route::post("add_sub_order_delivery",[SubOrderDeliveyController::class,'addData']);
    Route::post("add_sub_order_delivery/add_manually",[SubOrderDeliveyController::class,'addDataManually']);
    
    Route::post("add_sub_order_delivery_weekly",[SubOrderDeliveyController::class,'addDataWeekely']);
        Route::post("add_sub_order_delivery_weekly/add_manually",[SubOrderDeliveyController::class,'addDataWeekelyManually']);
    Route::post("add_normal_order_delivery",[SubOrderDeliveyController::class,'addNormalOrderData']);
    Route::get("get_sub_order_delivery/order/{id}",[SubOrderDeliveyController::class,'getDataByOrderId']);
   

    Route::post("update_web_page",[WebPageController::class,'updateData']);

    Route::get("get_settings",[AppSettingController::class,'getDataAllPages']);
    Route::get("get_settings/{id}",[AppSettingController::class,'getDataBySettingId']);
    Route::post("update_settings",[AppSettingController::class,'updateData']);
    
        
    Route::post("add_pincode",[AllowPincodeController::class,'addData']);
    Route::get("get_pincode",[AllowPincodeController::class,'getDataAllPincode']);
    Route::get("get_pincode/pincode/{pincode}",[AllowPincodeController::class,'getDataByPincode']);
    Route::post("delete_pincode",[AllowPincodeController::class,'delete']);

    Route::post("add_testimonial",[TestimonialController::class,'addData']);
    Route::post("update_testimonial",[TestimonialController::class,'updateDetails']);
    Route::post("delete_testimonial",[TestimonialController::class,'delete']);

    Route::post("testimonial/upload_image",[TestimonialController::class,'uploadImage']);
    Route::post("testimonial/delete_image",[TestimonialController::class,'deleteImage']);
    
    Route::get("get_user_notification",[UserNotificationController::class,'getDataAllNoti']);
    Route::get("get_user_notification/date/{date}",[UserNotificationController::class,'getDataByDate']);
    Route::post("add_user_notification",[UserNotificationController::class,'addData']);
    Route::get("get_user_notification/{id}",[UserNotificationController::class,'getDataById']);
    Route::post("send_low_wallet_notificaiton",[UserNotificationController::class,'sendLowWalletNotification']);

    
    Route::post("send_notification_to_topic",[sendNotificationController::class,'sendReqFirebaseNotificationToTopic']);
    
    Route::get("get_report/delivery",[ReportController::class,'getDataAllDeliveryReport']);
    Route::get("get_report/delivery/{userId}",[ReportController::class,'getDataAllDeliveryByUser']);

    Route::get("get_report/delivery/{firstDate}/{lastDate}",[ReportController::class,'getDataAllDeliveryReportByDate']);
    Route::get("get_report/delivery/{userId}/{firstDate}/{lastDate}",[ReportController::class,'getDataAllDeliveryReportByDateAndUser']);
    
    Route::post("update_payment_getway",[PaymentGetwayController::class,'updateData']);
    Route::get("get_payment_getway",[PaymentGetwayController::class,'getDataAllData']);
    Route::get("get_payment_getway/active",[PaymentGetwayController::class,'getDataAcive']);
    
    Route::post('add_available_delivery_location', [AvailableDeliveryLocationController::class, 'addData']);
    Route::post('delete_available_delivery_location', [AvailableDeliveryLocationController::class, 'delete']);
    
    Route::post('add_social_media', [SocialMediaController::class, 'addData']);
    Route::post('delete_social_media', [SocialMediaController::class, 'delete']);


    Route::post("update_web_app_settings",[WebAppSettingsController::class,'updateData']);

    
       Route::post("upload_image_only",[UploadImageController::class,'uploadImageOnly']);

       Route::get("get_specific_notification",[SpecificNotificationController::class,'getDataAllNoti']);
       Route::get("get_specific_notification/{id}",[SpecificNotificationController::class,'getDataByUId']);

       
           Route::get("get_invoice_settings",[InvoiceSettingController::class,'getDataAllData']);
               Route::post("update_invoice_settings",[InvoiceSettingController::class,'updateData']);
                              Route::get("get_invoice_settings/{id}",[InvoiceSettingController::class,'getDataDataById']);


    
   });
       Route::get("get_available_delivery_location",[AvailableDeliveryLocationController::class,'getDataAllData']);
      Route::get("get_social_media",[SocialMediaController::class,'getDataAllData']);
    Route::get("get_web_app_settings",[WebAppSettingsController::class,'getDataAllData']);
    Route::post("login",[LoginController::class,'login']);
    Route::post("login/mobile",[LoginController::class,'loginMobile']);
    Route::post("user_check/mobile",[LoginController::class,'checkUserRegMobile']);
    Route::post("add_user",[UsersController::class,'addData']);
    Route::post("update_pass",[UsersController::class,'updatePassword']);

    Route::get('invoice/{id}', [InvoiceController::class, 'Invoice']);
    Route::get('sub_invoice/{month}/{year}/{id}', [InvoiceController::class, 'SubInvoice']);

    Route::get("get_web_page/page/{id}",[WebPageController::class,'getDataByPageId']);
    
    Route::get("get_testimonial",[TestimonialController::class,'getData']);
    Route::get("get_testimonial/{pincode}",[TestimonialController::class,'getDataById']);
       Route::get("checkorderassi",[OrderAssignController::class,'check']);
       
             Route::post('forget-password', [ForgotPasswordController::class, 'ForgetPasswordStore']);
       Route::post('reset-password', [ForgotPasswordController::class, 'ResetPasswordStore']);


       
       
   //  Route::post("add_usep",[UsersController::class,'addData']);
    
