<!DOCTYPE html>
<html>
<head>
    <title>Invoice </title>
</head>
<style type="text/css">
    body{
        font-family: 'Roboto Condensed', sans-serif;
    }
    .m-0{
        margin: 0px;
    }
    .p-0{
        padding: 0px;
    }
    .pt-5{
        padding-top:5px;
    }
    .mt-10{
        margin-top:10px;
    }
    .text-center{
        text-align:center !important;
    }
    .w-100{
        width: 100%;
    }
    .w-50{
        width:50%;   
    }
    .w-85{
        width:85%;   
    }
    .w-15{
        width:15%;   
    }
    .logo img{
        width:200px;
        height:60px;        
    }
    .gray-color{
        color:#5D5D5D;
    }
    .text-bold{
        font-weight: bold;
    }
    .border{
        border:1px solid black;
    }
    table tr,th,td{
        border: 1px solid #d2d2d2;
        border-collapse:collapse;
        padding:7px 8px;
    }
    table tr th{
        background: #F4F4F4;
        font-size:15px;
    }
    table tr td{
        font-size:13px;
    }
    table{
        border-collapse:collapse;
    }
    .box-text p{
        line-height:10px;
    }
    .float-left{
        float:left;
    }
    .total-part{
        font-size:16px;
        line-height:12px;
    }
    .total-right p{
        padding-right:20px;
    }
</style>
<body>
<div class="head-title">
    <h1 class="text-center m-0 p-0">Invoice</h1>
</div>
<div class="add-detail mt-10">
    <div class="w-50 float-left mt-10">
        <!-- <p class="m-0 pt-5 text-bold w-100">Invoice Id - <span class="gray-color">#1</span></p> -->
        <p class="m-0 pt-5 text-bold w-100">Order Id - <span class="gray-color"><?php echo e($order->id); ?></span></p>
        <p class="m-0 pt-5 text-bold w-100">Order Date - <span class="gray-color"><?php echo e($order->created_at); ?></span></p>
    </div>
    <div class="w-50 float-left logo mt-10">
        <img src="https://basketapp.techashna.com/logo_200_60.png" alt="Logo">
    </div>
    <div style="clear: both;"></div>
</div>
<div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50">From</th>
            <th class="w-50">To</th>
        </tr>
        <tr>
            <td>
                <div class="box-text">
                    <p>CAPTAIN'S FRESH PRIVATE LIMITED</p>
                    <p>REG. ADDRESS: H.NO.276/S.NO. 64</p>
                    <p>NADODE ROAD KHALAPUR RAIGARH</p>
                    <p>MAHARASHTRA, INDIA - 410202</p>                    
                </div>
            </td>
            <td>
                <div class="box-text">
                    <p><?php echo e($order->name); ?></p>
                    <p><?php echo e($order->flat_no); ?> <?php echo e($order->apartment_name); ?> <?php echo e($order->area); ?> <?php echo e($order->landmark); ?></p>
                    <p><?php echo e($order->city); ?> <?php echo e($order->pincode); ?></p>                    
                    <p>Contact: <?php echo e($order->s_phone); ?></p>
                </div>
            </td>
        </tr>
    </table>
</div>
<!-- <div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50">Payment Method</th>
            <th class="w-50">Shipping Method</th>
        </tr>
        <tr>
            <td>Cash On Delivery</td>
            <td>Free Shipping - Free Shipping</td>
        </tr>
    </table>
</div> -->
<div class="table-section bill-tbl w-100 mt-10">
    <table class="table w-100 mt-10">
        <tr>
            <th class="w-50">ID</th>
            <th class="w-50">Product Name</th>
            <th class="w-50">Subscription</th>
            <th class="w-50">Month</th>
            <th class="w-50">Day</th>
            <th class="w-50">MRP</th>
            <th class="w-50">Price</th>
            <th class="w-50">Qty</th>
            <th class="w-50">Tax(%)</th>
            <th class="w-50">Total</th>
        
        </tr>
        <tr align="center">
            <td><?php echo e($order->product_id); ?></td>
            <td><?php echo e($order->title); ?> - <?php echo e($order->qty_text); ?></td>
            <td><?php echo e($subName); ?></td>
            <td><?php echo e($monthName); ?> - <?php echo e($year); ?></td>
            <td><?php echo e($deliveryCount); ?></td>
            <td><?php echo e($order->mrp); ?></td>
            <td><?php echo e($order->price); ?></td>
            <td><?php echo e($order->qty); ?></td>
            <td><?php echo e($order->tax); ?></td>
            <td><?php echo e($newOrderAmount); ?></td>
        </tr>
     
        <tr>
            <td colspan="10">
                <div class="total-part">
                    <div class="total-left w-85 float-left" align="right">
                        <!-- <p>Sub Total</p>
                        <p>Tax (18%)</p> -->
                        <p>Total Payable</p>
                    </div>
                    <div class="total-right w-15 float-left text-bold" align="right">
                        <!-- <p>$7600</p>
                        <p>$400</p> -->
                       
                        <p>INR <?php echo e($newOrderAmount); ?></p>
                    </div>
                    <div style="clear: both;"></div>
                </div> 
            </td>
        </tr>
    </table>
    <p>GSTIN : 27AAICC9171F1ZG // PAN : AAICC9171F // CIN : U01100MH2020PTC344500
// MOB : + 91 9321414254 // +91 9321414109 //+91 9321414119 // EMAIL :
sales@captainsfarm.in // FSSAI NUMBER : 11521024001163// Milk HSN : 0401 //Paneer HSN : 0406</p>
</div>
</html><?php /**PATH D:\Apps\Milk\laravel_api\resources\views/sub_invoice_pdf.blade.php ENDPATH**/ ?>